import glob
import numpy as np
from PIL import Image
import imageio.v2 as imageio

# Collect all PNG frames in the current directory
files = sorted(glob.glob("*.png"))
print("Found", len(files), "frames...")

frames = []
target_size = None

for f in files:
    # Ensure 3-channel RGB for video encoding
    img = Image.open(f).convert("RGB")

    # Fix all frames to the same size, based on the first image
    if target_size is None:
        target_size = img.size          # (width, height) from first frame
    elif img.size != target_size:
        img = img.resize(target_size, Image.BICUBIC)

    frames.append(np.array(img))

# Write MP4 video using H.264 codec
output_name = "ECT_Dark_Halo_Stage1.mp4"
imageio.mimsave(
    output_name,
    frames,
    fps=2,
    codec="libx264"
)

print("Done. Output saved as", output_name)
